#include <stdio.h>

int memo[1001][1001];

int is_deletable(int l, int r, int a[]) {
    // Check if the subarray l to r is already sorted
    if (l == r) {
        return 1;
    }
    if (memo[l][r] != 0) {
        return memo[l][r];
    }
    int sorted = 2;
    for (int i = l+1; i <= r; i++) {
        if (a[i] < a[i-1]) {
            sorted--;
            if (sorted == 0) {
                memo[l][r] = -1;  // Not deletable
                return -1;
            }
        }
    }
    memo[l][r] = sorted;  // 1 for already sorted, 2 for partially sorted
    return sorted;
}

int main() {
    int a[] = {1, 3, 5};
    int l = 0;
    int r = 2;
    int deletable = is_deletable(l, r, a);
    if (deletable==-1) {
        printf("NO\n");
    } else {
        printf("YES\n");
    }
    return 0;
}